; Motorised potentiometer remote controlled volume for low noise stereo amplifier

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _XT_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
; Define variables at memory locations

; RAM
; bank 0 

REMOTE_M	equ	H'20'	; remote control input ms byte
REMOTE_L	equ	H'21'	; remote control input LS byte
REM_FLG		equ	H'22'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'23'	; interrupt count for polling remote control signal
REM_COD		equ	H'24'	; remote control bit counter mode.
TOGGLE		equ	H'25'	; remote control toggle bit
MUTE		equ	H'26'	; mute counter
TG_BIT		equ	H'27'	; toggle bit stored flag
MUTE_FG		equ	H'28'	; mute flag
VALUE_1		equ	H'29'	; delay value
VALUE_2		equ	H'2A'	; delay value
TEMP_R		equ	H'2B'	; remote code temporary
FLG_HL		equ	H'2C'	; high or low remote control sign
TIMER1		equ	H'2D'	; timer least significant byte
TIMER2		equ	H'2E'	; timer most significant byte
MUTE_OP		equ	H'2F'	; mute in operation
SLEEPT		equ	H'30'	; sleep timer
MOTOR_SLIP	equ	H'31'	; motor slippage flag

; all banks ram
W_TMP		equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 

; define reset and interrupt vector start addresses

	org		0			; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4			; interrupt vector 0004h, start interrupt routine here
	
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0

; check interrupt	
		
	btfsc	INTCON,TMR0IF	; TMRO overflow interrupt flag then goto counter
	goto	COUNTER		; TMRO overflow so increase counter 
	bcf		INTCON,INTF	; clear interrupt flag for RB0
	goto	RECLAIM		; end of interrupt reclaim w and status

; adjust interrupt rate with counter

COUNTER
	movlw	D'207'		; freq is 4MHz/4/2/50. = 100us
	addwf	TMR0,f		; add to timer register and takes 2 cycles to start counting
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag

; increase timer

	incfsz	TIMER1,f	; increase value least significant byte
	goto	REMST		; start remote control
	incf	TIMER2,f	; increase ms byte

; check if RB0 has gone low for start of remote control sequence

REMST
	bcf		PORTA,0		; tracer for remote decode

RM_SQ
	btfsc	REM_FLG,0	; has remote control sequence started		
	goto	REM_SEQ
	btfsc	PORTB,0		; is RB0 low 
	goto	RECLAIM
	bsf		REM_FLG,0	; set beginning of remote control flag
	
	movlw	D'22'		; initial time period to wait till next start bit
	movwf	REM_CNT
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf		REMOTE_L,0	; set first bit in remote control sequence
	clrf	FLG_HL		; clear bit 1 in high low flag
	bsf		REM_FLG,7	; start bit flag set	
	bsf		PORTA,3		; decode out 
	bsf		PORTB,1		; acknowledge LED driver
	bsf		PORTA,0		; tracer for decode (reads level at this point) 
	goto 	RECLAIM

REM_SEQ
	btfsc	REM_FLG,1	; has it finished
	goto	RECLAIM
	decfsz	REM_CNT,f	; decrease interrupt counter for timing
	goto	CKEDGE		; check if change in level
	bcf		REM_FLG,7	; clear start bit flag
	movlw	D'18'		; 18 x 100us = 1.8ms or period between valid bits
	movwf	REM_CNT
	rlf		REMOTE_L,f	; least sig byte in remote control code sequence
	rlf		REMOTE_M,f	; most sig byte 
	movf	PORTB,w		; check bit 2 portA
	andlw	B'00000001'	; mask out bits except bit 0
	movwf	FLG_HL		; place in flag
	btfsc	PORTB,0		; check if high or low
	goto	HI			; high so clear
	bsf		REMOTE_L,0	; if low set this bit
	bsf		PORTB,1		; if high clear acknowledge bit
	bsf		PORTA,3		; decode out
	goto	BY_HI		; bypass high
HI	
	bcf		REMOTE_L,0	; clear 0 bit
;	bcf		PORTB,1 	; acknowledge
	bcf		PORTA,3		; decode
BY_HI		
	bsf		PORTA,0		; tracer  
	decfsz	REM_COD,f	; decrease shift register count
	goto	RECLAIM
	bsf		REM_FLG,1	; set end of remote control decoding flag
	goto	RECLAIM

; align change in level (edge detect) with REM_CNT counter
 
CKEDGE
	btfsc	REM_FLG,7	; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'00000001'	; select bit 0 for PORTB,0
	andwf	PORTB,w		; bit 0
	xorwf	FLG_HL,w	; compare PORTB,0 with FLAG (previous level)		
	btfsc	STATUS,Z	; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'00000001'	; select bit 0 for PORTB,0
	andwf	PORTB,w		; bit 0 select 
	movwf	FLG_HL		; reload new level
	movlw	H'3'		; count of 3 for REM_CNT
	subwf	REM_CNT,w	; is REM_CNT larger or equal to 3
	btfss	STATUS,C
	goto	RECLAIM		; smaller than 3 
	movf	REM_CNT,w
	sublw	H'6'		; check if 6 or less
	btfss	STATUS,C
	goto	RECLAIM		; larger than 6 
	movlw	H'4'
	movwf	REM_CNT		; set REM_CNT to 4 to align with change in level
	
; end of interrupt reclaim w and status 

RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN
	movlw	D'10'
	movwf	SLEEPT		; time before sleep
	clrf	MUTE_OP		; mute in operation
	clrf	TG_BIT		; clear toggle bit stored flag
	clrf	REM_CNT		; remote control polling counter
	clrf	REM_FLG		; remote control flag status
	clrf	MUTE		; mute counter
	clrf	MUTE_FG		; mute flag

; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11000001'	; RB1-RB5 outputs
	movwf	TRISB		; port B data direction register
	movlw	B'01000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups enabled, RB0 interrupt on 0
	movlw   B'00010100'	; (RA4,RA2 inputs) 
	movwf   TRISA		; port A data direction register

; analog inputs, A/D

	movlw	B'00000100'	; AN2 is analog inputs
	movwf	ANSEL
	movlw	B'10000000'	; right justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01010000'	; Fosc, channel 2 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

	movlw	B'00111100'	; Acknowledge LED off Q2,Q4 on Q1,Q3 off 
	movwf	PORTB		; motor off, terminals both low
	bcf		PORTB,1		; Acknowledge LED off
	bcf		PORTA,1		; Mute LED off
	
	movlw	B'00000000'	; mute LED off, tracer and decode low
	movwf	PORTA


; interrupt enable 

	bsf		INTCON,TMR0IE; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above

	
; decode remote control signal
; delay

CK_AGN
	movf	SLEEPT,w	; sleep timing
	btfsc	STATUS,Z
	goto	T_SET
	decf	SLEEPT,f	; decrease until zero
T_SET
	movlw	D'100'		; set delay period of about 120ms between codes
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'255'		; set delay period value 2 
LP_1
	movwf	VALUE_2		; VALUE_2 = w
LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2

; check during delay for remote control entered flag
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D
	
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1

; check motor slippage
	call	ACQUIRE_AD	
	btfss	MOTOR_SLIP,0; if low stop motor
	goto	MOT_OFF		; stop motor

; remote control decoding
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D		; check codes

	movlw	B'00111100'	; Q1,Q3 off Q2,Q4 on
	movwf	PORTB		; motor off
	
	movf	SLEEPT,w	; sleep timing
	btfss	STATUS,Z	; if zero then sleep	
	goto	CK_AGN
	bsf		INTCON,INTE	; set interrupt enable for RB0
	sleep				; sleep mode
	nop
	bcf		INTCON,INTE	; disable interrupt for RB0
	bcf		INTCON,INTF	; flag cleared
	clrf	REM_FLG		; clear any remote control flags
	goto	CK_AGN

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
; but first check which code is selected via RB6, RB7
	
CODE_D
	movlw	D'10'
	movwf	SLEEPT		; time before sleep
	btfsc	PORTB,7		; if high TV1 or SAT2
	goto	SET_DEVICE
	btfsc	PORTB,6	
	goto	SAT_1		; RB7 low, RB6 high
	goto	SAT_2		; RB7 low, RB6 low
SET_DEVICE
	btfss	PORTB,6		; 
	goto	SAT_2		; RB7 high, RB6 low
;	goto	TV_1		; RB7 high, RB6 high 	

; code for television (TV1)

TV_1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	
	movf	REMOTE_L,w
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET  
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	MUTE_ST
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_DN 
	goto	CLR_RMF

; code for CD. (Not Used)

CD1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110101'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	
	movf	REMOTE_L,w
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET  
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	MUTE_ST
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_DN 
	goto	CLR_RMF

; satellite decoding SAT1 & SAT2
	
SAT_1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	movf	REMOTE_L,w	;  least sig remote code
	
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET
	movf	REMOTE_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	MUTE_ST 
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_DN 	
  	goto	CLR_RMF

SAT_2
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit

	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF		; clear remote flag
	
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REMOTE_L,w
	xorlw	B'10010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET 
	movf	REMOTE_L,w
	xorlw	B'10001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	MUTE_ST  
	movf	REMOTE_L,w	; least sig remote code
	xorlw	B'10100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_UP
	movf	REMOTE_L,w
	xorlw	B'10100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REM_DN 
	goto	CLR_RMF

MOT_OFF
	movlw	B'00111100'	; Q1,Q3 off Q2,Q4 on
	movwf	PORTB		; motor off
	goto	CK_AGN
CLR_RMF	
	movlw	D'6'		; set delay period of about 1.5ms 
	call	DELAYT		; delay
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	clrf	REM_FLG		; remote flag cleared
	goto	MOT_OFF

; up volume. 

UP_SET	
;	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	bcf		MUTE_FG,1	; mute flag off
	bcf		PORTA,1		; Mute LED off
	bsf		PORTB,5		; Q3 off
	bsf		PORTB,2		; Q4 on	
	bcf		PORTB,3		; Q2 off
 	bcf		PORTB,4		; Q1 on

; motor on (up)	
CK_DEL
	movlw	D'10'		; set delay period  
	call	DELAYT		; delay
	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	clrf	MUTE_OP		; mute operation off	
	goto	CK_AGN

DN_SET	
;	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	bcf		MUTE_FG,1	; mute flag off
	bcf		PORTA,1		; Mute LED off
	bsf		PORTB,4		; Q1 off
	bsf		PORTB,3		; Q2 on
	bcf		PORTB,2		; Q4 off
 	bcf		PORTB,5		; Q3 on
;
; motor on (down)
	clrf	MUTE_OP		; mute operation off	
	goto	CK_DEL

REM_UP
;	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	bcf		MUTE_FG,1	; mute flag off
	bcf		PORTA,1		; Mute LED off
	bsf		PORTB,5		; Q3 off
	bsf		PORTB,2		; Q4 on	
	bcf		PORTB,3		; Q2 off
 	bcf		PORTB,4		; Q1 on

; motor on (up)	
CK_DLY
	movlw	D'50'		; set delay period  
	call	DELAYT		; delay
	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	clrf	MUTE_OP		; mute operation off
	movlw	B'00111100'	; Q1,Q3 off Q2,Q4 on
	movwf	PORTB		; motor off	
	goto	CK_AGN

REM_DN	
;	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	bcf		MUTE_FG,1	; mute flag off
	bcf		PORTA,1		; Mute LED off
	bsf		PORTB,4		; Q1 off
	bsf		PORTB,3		; Q2 on
	bcf		PORTB,2		; Q4 off
 	bcf		PORTB,5		; Q3 on

; motor on (down)
	clrf	MUTE_OP		; mute operation off
	goto	CK_DLY

; Mute operation
	
MUTE_ST
	btfsc	MUTE_OP,0	; is mute already in operation
	goto	MUTE_B		; bypass mute toggle when muting process in action
	bsf		MUTE_OP,0	; mute in operation
	movlw	D'10'		; set delay period  
	call	DELAYT		; delay

	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low

	clrf	TIMER1
	clrf	TIMER2		; clear timers

	btfss	MUTE_FG,1	; if set clear if clear set
	goto	ST_FG1
	bcf		MUTE_FG,1	; mute off
	bcf		PORTA,1		; Mute LED off

	bsf		PORTB,5		; Q3 off
	bsf		PORTB,2		; Q4 on	
	bcf		PORTB,3		; Q2 off
 	bcf		PORTB,4		; Q1 on

; motor on (up)

DELY
	movlw	D'200'		; set delay period when motor first switched on
DEL2
	call	DELAYT		; delay
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low

; check motor slippage
	call	ACQUIRE_AD
	
	btfss	MOTOR_SLIP,0; if low stop motor
	goto	MOT_M		; stop motor
	btfss	PORTA,4		; if RA4 low then do not mute off
	goto	MOT_M
	movf	MUTE,f		; count down time for motor to wind up
	btfsc	STATUS,Z	; if zero then stop
	goto	MOT_M
	decfsz	MUTE,f		; decrease until zero
	goto	NOT_0
	goto	MOT_M		; end of mute
NOT_0
	btfss	MUTE,2		; flashing LED
	goto	SET_LED	
	bcf		PORTA,1		; LED off
	goto	RCE			; remote control entered
SET_LED
	bsf		PORTA,1			; LED on
RCE	btfss	TIMER2,5	; .8 seconds
	goto	DELY_C
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D
	movlw	D'47'		; delay period between mute counting
	goto	DEL2
MOT_M
	bcf		PORTA,1		; LED off when MUTE finished
	clrf	MUTE_OP		; mute operation complete
	goto	CLR_RMF
	
DELY_C
	clrf	REM_FLG		; remote flag cleared
	movlw	D'47'		; delay period between mute counting
	goto	DEL2

ST_FG1
	bsf		MUTE_FG,1	; mute flag set
	bsf		PORTA,1		; Mute LED on
	clrf	MUTE		; mute counter cleared

; start motor down

	bsf		PORTB,4		; Q1 off
	bsf		PORTB,3		; Q2 on
	bcf		PORTB,2		; Q4 off
 	bcf		PORTB,5		; Q3 on

; motor on (down)		
DELAY
	movlw	D'200'		; set delay period when motor switched on
DEL1
	call	DELAYT		; delay
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low

; check motor slippage
	call	ACQUIRE_AD
		
	btfss	MOTOR_SLIP,0; if low stop motor
	goto	MOT_OM		; stop motor
	incfsz	MUTE,f		; count up time for motor to wind down
	goto	MU_LED
	bcf		PORTA,1		; timeout mute off
	goto	CLR_RMF		; time out as MUTE=0 so stop
MU_LED
	btfss	MUTE,2		; flashing LED
	goto	CLR_LED	
	bsf		PORTA,1		; LED on
	goto	RCEF		; remote control entered flag?
CLR_LED
	bcf		PORTA,1			; LED off
RCEF
	btfss	TIMER2,5	; 0.8 seconds timer
	goto	DEL_C
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D
	movlw	D'47'		; delay period between mute counting
	goto	DEL1
MOT_OM
	clrf	MUTE_OP		; mute operation complete
	bsf		PORTA,1		; LED on during MUTE
	goto	CLR_RMF

DEL_C
	clrf	REM_FLG		; remote flag cleared
	movlw	D'47'		; delay period between mute counting
	goto	DEL1

MUTE_B
	bcf		MUTE_FG,1	; clear mute flag
	bcf		PORTA,1		; mute LED off
	movlw	B'00111100'	; Q1,Q3 off Q2,Q4 on
	movwf	PORTB		; motor off
	movlw	D'255'		; set delay period  
	call	DELAYT		; delay
	movlw	D'255'		; set delay period  
	call	DELAYT		; delay
	clrf	REM_FLG		; remote flag cleared
	bcf		PORTB,1		; acknowledge LED off
	bcf		PORTA,3		; decode out low
	bcf		PORTA,0		; tracer low
	clrf	MUTE_OP		; mute operation off	
	goto	CK_AGN

; subroutines

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0
	sublw	D'40'		; 200mV using ls 10 bits
	bsf		MOTOR_SLIP,0; set flag for under value
	btfss	STATUS,C	; if C = 0 then greater than 200mV then stop motor
	clrf	MOTOR_SLIP	; clear flag

; check ms bits
	movf	ADRESH,w
	btfss	STATUS,Z	; if zero keep flag setting. If not zero clear MOTOR_SLIP to stop motor
	clrf	MOTOR_SLIP
	return

; delay subroutine

DELAYT
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'255'		; set delay period value 2 
LP_X
	movwf	VALUE_2		; VALUE_2 = w
LP_Y
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_Y
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_X
	return
	
	end


	
